package org.msh.tb.bd.tbforms.query.tb10;

import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.Workspace;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.util.List;

/**
 * Created by Mauricio on 11/03/2017.
 * Query database for Tb Form 10 Block 5A Result
 */
public class TBForm10Block5AQuery implements TbFormQuery {

    @Override
    public List<Object[]> queryDB(Tbunit tbunit, AdministrativeUnit adminUnit, Workspace workspace, Quarter selectedQuarter, EntityManager em) {
        String qStr;
        Query query;

        // HIV tested
        qStr = "select c.infectionSite, c.patientType, c.caseDefinition,  p.gender, hiv.result, count(*)"
                + " from TbCaseBD c join c.patient p join c.resHIV hiv "
                + " where c.registrationDate between :iniDate and :endDate %restriction% "
                + " and (c.patientType in (0,48) or ( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47) ) )"
                + " and c.classification = 0 and c.diagnosisType = 1 and c.age is not null and p.gender is not null "
                + " and hiv.id = ( "
                    + " select max (hiv2.id) "
                    + " from ExamHIV hiv2 "
                    + " where hiv2.tbcase.id = hiv.tbcase.id and hiv2.date = ( "
                        + " select max(hiv3.date) "
                        + " from ExamHIV hiv3 "
                        + " where hiv3.tbcase.id = hiv2.tbcase.id and (hiv3.date between :iniDate and :endDate ) ) )"
                + " group by c.infectionSite, c.patientType, c.caseDefinition,  p.gender, hiv.result ";

        if (tbunit != null) {
            // add tbunit restriction
            qStr = qStr.replace("%restriction%", "and c.notificationUnit.id = :unitId");
            query = em.createQuery(qStr);
            query.setParameter("unitId", tbunit.getId());
        } else if (adminUnit != null) {
            // add adminunit restriction
            qStr = qStr.replace("%restriction%", "and c.notificationUnit.adminUnit.code like :code");
            query = em.createQuery(qStr);
            query.setParameter("code", adminUnit.getCode() + "%");
        } else if (workspace != null) {
            // add workspace restriction
            qStr = qStr.replace("%restriction%", "and c.patient.workspace.id = :wsId");
            query = em.createQuery(qStr);
            query.setParameter("wsId", workspace.getId());
        } else {
            throw new RuntimeException("TbFormDbService: Tbunit, adminunit or workspace must be set.");
        }

        return query.setParameter("iniDate", selectedQuarter.getIniDate())
                .setParameter("endDate", selectedQuarter.getEndDate())
                .getResultList();
    }
}
